/*--------------------------------------
    Foundation General Library

    Marc Wolfgram,  6/ 8/93 22:49:43
*/
#pragma noroot
#include <foundation.h>
                                    /*    1 2 3 4 5 6 7 8 9 0 1 2  */
extern fResDataRec      _FPB_0;     /*  9 w w l   h   w p          */
extern fResData2Rec     _FPB_1;     /*  7 w w l   l   w            */
extern fResRefRec       _FPB_2;     /*  5 w w l   w                */
extern fResNameRec      _FPB_3;     /*  6 w w l   p                */
extern fResLinkRec      _FPB_4;     /* 12 w w h   w l   w l   w w  */
extern fLoadFileRec     _FPB_5;     /* 11 w h   l   l   l   l      */
extern fPrivateDataRec  _FPB_6;     /* 12 w p   l   w h   w w l    */
extern fResConverterRec _FPB_7;     /*  5 w w l   w                */
extern fResCopyRec      _FPB_8;     /* 11 w w l   l   w w w p      */
extern fMarqueeRec      _FPB_9;     /*  6 w w p   h                */
extern fColorRec        _FPB_10;    /* 12 w P   w w w w l   w h    */

word _FTOOLERROR(word);

segment "_FDNGENLIB";

pascal void fAddPrivateData2(GrafPortPtr winPtr, long taskMask, word sig, handle data, word group, word type, long id)
{
    _FPB_6.pCount = 7;
    _FPB_6.winPtr = (Pointer) winPtr;
    _FPB_6.remTaskMask = taskMask;
    _FPB_6.remSignature = sig;
    _FPB_6.Data = data;
    _FPB_6.groupSignature = group;
    _FPB_6.resType = type;
    _FPB_6.resID = id;

    _FTOOLERROR(FSTACK(26, &_FPB_6));
}

pascal long fAddResource2(word type, long id, handle data, word attr, word fid, char *name)
{
    _FPB_0.pCount = 4;
    _FPB_0.resType = type;
    _FPB_0.resID = id;
    _FPB_0.resData = data;
    _FPB_0.special = attr;

    if (fid) {
        _FPB_0.pCount = 5;
        _FPB_0.resFileID = fid;
    }
    else
        _FPB_0.resFileID = 0;

    if (name && name[0]) {
        _FPB_0.pCount = 6;
        _FPB_0.resName = name;
    }

    _FTOOLERROR(FSTACK(1, &_FPB_0));

    return _FPB_0.resID;
}

pascal handle fBuildLinkHand2(word hostType, long hostID, word fid, word *index)
{
    _FPB_4.pCount = 4;
    _FPB_4.hostType = hostType;
    _FPB_4.hostID = hostID;

    if (fid) {
        _FPB_4.pCount = 8;
        _FPB_4.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(11, &_FPB_4));

    if (index)
        *index = _FPB_4.index;

    return _FPB_4.linkHand;
}

pascal word fColorPalette2(word h, word v, word color, word row, word col, word mode, long resID, word fid)
{
    _FPB_10.pCount = 2;
    _FPB_10.Loc.h = h;
    _FPB_10.Loc.v = v;
    _FPB_10.Color = color;

    if (row && col) {
        _FPB_10.pCount = 7;
        _FPB_10.Row = row;
        _FPB_10.Col = col;
        _FPB_10.Mode = mode;
        _FPB_10.resID = resID;
        _FPB_10.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(39, &_FPB_10));

    return _FPB_10.Color;
}

pascal long fCopyResource2(word type, long oldID, word newID, word attr, word oldFID, word newFID, char *newName)
{
    _FPB_8.pCount = 6;
    _FPB_8.resType = type;
    _FPB_8.resID = oldID;
    _FPB_8.newID = newID;
    _FPB_8.attr = attr;
    _FPB_8.resFileID = oldFID;
    _FPB_8.newFileID = newFID;

    if (newName && newName[0]) {
        _FPB_8.pCount = 7;
        _FPB_8.resName = newName;
    }

    _FTOOLERROR(FSTACK(25, &_FPB_8));

    return _FPB_8.newID;
}

pascal long fCountResources2(word type, word fid)
{
    _FPB_1.pCount = 3;
    _FPB_1.resType = type;

    if (fid) {
        _FPB_1.pCount = 4;
        _FPB_1.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(18, &_FPB_1));

    return _FPB_1.result;
}

pascal void fDetachResource2(word type, long id, word fid)
{
    _FPB_2.pCount = 2;
    _FPB_2.resType = type;
    _FPB_2.resID = id;

    if (fid) {
        _FPB_2.pCount = 3;
        _FPB_2.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(5, &_FPB_2));
}

pascal void fDisposeLinkHand2(handle linkHand)
{
    _FPB_4.pCount = 2;
    _FPB_4.linkHand = linkHand;

    _FTOOLERROR(FSTACK(28, &_FPB_4));
}

pascal handle fExtendLinkHand2(handle linkHand, word hostType, long hostID, word resType, long resID, word *index)
{
    _FPB_4.pCount = 6;
    _FPB_4.linkHand = linkHand;
    _FPB_4.hostType = hostType;
    _FPB_4.hostID = hostID;
    _FPB_4.resType = resType;
    _FPB_4.resID = resID;

    _FTOOLERROR(FSTACK(10, &_FPB_4));

    *index = _FPB_4.index;

    return _FPB_4.linkHand;
}

pascal handle fFindHostLink2(word resType, long resID, word *hostType, long *hostID, word *index, word *resCheck)
{
    _FPB_4.pCount = 7;
    _FPB_4.resType = resType;
    _FPB_4.resID = resID;

    _FTOOLERROR(FSTACK(36, &_FPB_4));

    if (index)
        *index = _FPB_4.index;
    if (hostType)
        *hostType = _FPB_4.hostType;
    if (hostID)
        *hostID = _FPB_4.hostID;
    if (resCheck)
        *resCheck = _FPB_4.resCheck;

    return _FPB_4.linkHand;
}

pascal long fGetEditorStatus2(word type, long id)
{
    _FPB_1.pCount = 3;
    _FPB_1.resType = type;
    _FPB_1.resID = id;

    _FTOOLERROR(FSTACK(33, &_FPB_1));

    return _FPB_1.result;
}

pascal handle fGetFileName2(void)
{
    _FPB_5.pCount = 1;

    _FTOOLERROR(FSTACK(41, &_FPB_5));

    return _FPB_5.fileData;
}

pascal long fGetIndResource2(word type, long index, word fid)
{
    _FPB_1.pCount = 3;
    _FPB_1.resType = type;
    _FPB_1.result = index;

    if (fid) {
        _FPB_1.pCount = 4;
        _FPB_1.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(19, &_FPB_1));

    return _FPB_1.resID;
}

pascal word fGetKernalID2(void)
{
    _FTOOLERROR(FSTACK(40, 0L));

    return toolerror();
}

pascal handle fGetPrivateData2(GrafPortPtr winPtr, long *taskMask, word *sig)
{
    _FPB_6.pCount = 4;
    _FPB_6.winPtr = (Pointer) winPtr;

    _FTOOLERROR(FSTACK(15, &_FPB_6));

    if (taskMask)
        *taskMask = _FPB_6.remTaskMask;

    if (sig)
        *sig = _FPB_6.remSignature;

    return _FPB_6.Data;
}

pascal word fGetResourceAttr2(word type, long id, word fid)
{
    _FPB_0.pCount = 4;
    _FPB_0.resType = type;
    _FPB_0.resID = id;

    if (fid) {
        _FPB_0.pCount = 5;
        _FPB_0.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(22, &_FPB_0));

    return _FPB_0.special;
}

pascal void fGetResourceName2(word type, long id, char *name)
{
    _FPB_3.pCount = 3;
    _FPB_3.resType = type;
    _FPB_3.resID = id;
    _FPB_3.resName = name;

    _FTOOLERROR(FSTACK(8, &_FPB_3));

}

pascal long fGetResourceSize2(word type, long id, word fid)
{
    _FPB_1.pCount = 3;
    _FPB_1.resType = type;
    _FPB_1.resID = id;

    if (fid) {
        _FPB_1.pCount = 4;
        _FPB_1.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(19, &_FPB_1));

    return _FPB_1.result;
}

pascal void fGetStdTypeName2(word type, char *name)
{
    _FPB_3.pCount = 3;
    _FPB_3.resType = type;
    _FPB_3.resName = name;

    _FTOOLERROR(FSTACK(7, &_FPB_3));

}

pascal void fGetWindowTitle2(word type, long id, char *name)
{
    _FPB_3.pCount = 3;
    _FPB_3.resType = type;
    _FPB_3.resID = id;
    _FPB_3.resName = name;

    _FTOOLERROR(FSTACK(29, &_FPB_3));

}

pascal handle fLoadFileData2(long replyRecPtr, long promptRecPtr, long fTypeRecPtr, long filterProcPtr)
{
    _FPB_5.pCount = 5;
    _FPB_5.sfGet2ReplyRecPtr = replyRecPtr;
    _FPB_5.sfGet2PromptRefPtr = promptRecPtr;
    _FPB_5.sfGet2FileTypeRecPtr = fTypeRecPtr;
    _FPB_5.sfGet2FilterProcPtr = filterProcPtr;

    _FTOOLERROR(FSTACK(13, &_FPB_5));

    return _FPB_5.fileData;
}

pascal handle fLoadResource2(word type, long id, word *state, word fid, char *name)
{
    _FPB_0.pCount = 4;
    _FPB_0.resType = type;
    _FPB_0.resID = id;

    if (fid) {
        _FPB_0.pCount = 5;
        _FPB_0.resFileID = fid;
    }
    else
        _FPB_0.resFileID = 0;

    if (name) {
        _FPB_0.pCount = 6;
        _FPB_0.resName = name;
    }

    _FTOOLERROR(FSTACK(3, &_FPB_0));

    if (state)
        *state = _FPB_0.special;

    return _FPB_0.resData;
}

pascal handle fLoadScrap2(word *type, long *id, word scrap, word *fid)
{
    _FPB_0.pCount = 4;
    if (scrap == 0x8003)
        _FPB_0.pCount = 5;

    _FTOOLERROR(FSTACK(31, &_FPB_0));

    if (type && id) {
        *type = _FPB_0.resType;
        *id = _FPB_0.resID;
    }
    if (fid)
        *fid = _FPB_0.resFileID;

    return _FPB_0.resData;

}

pascal void fMarquee2(word action, GrafPortPtr winP, rgnListHndl rgnListHand)
{
    _FPB_9.pCount = 3;
    _FPB_9.action = action;
    _FPB_9.windowPtr = (Pointer) winP;
    _FPB_9.rgnListHand = rgnListHand;

    _FTOOLERROR(FSTACK(38, &_FPB_9));

}

pascal void fQueryLinkHand2(word index, handle linkHand, word *hostType, long *hostID, word *resType, long *resID, word *resCheck, word *fid)
{
    _FPB_4.pCount = 8;
    _FPB_4.index = index;
    _FPB_4.linkHand = linkHand;

    _FTOOLERROR(FSTACK(12, &_FPB_4));

    if (index)
        *index = _FPB_4.index;
    if (hostType)
        *hostType = _FPB_4.hostType;
    if (hostID)
        *hostID = _FPB_4.hostID;
    if (resType)
        *resType = _FPB_4.resType;
    if (resID)
        *resID = _FPB_4.resID;
    if (resCheck)
        *resCheck = _FPB_4.resCheck;
    if (fid)
        *fid = _FPB_4.resFileID;

}

pascal void fRelPrivateData2(GrafPortPtr winPtr)
{
    _FPB_6.pCount = 1;
    _FPB_6.winPtr = (Pointer) winPtr;

    _FTOOLERROR(FSTACK(27, &_FPB_6));
}

pascal void fReleaseResource2(word type, long id, word fid)
{
    _FPB_2.pCount = 2;
    _FPB_2.resType = type;
    _FPB_2.resID = id;

    if (fid) {
        _FPB_2.pCount = 3;
        _FPB_2.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(4, &_FPB_2));
}

pascal void fRemoveResource2(word type, long id, word fid)
{
    _FPB_2.pCount = 2;
    _FPB_2.resType = type;
    _FPB_2.resID = id;

    if (fid) {
        _FPB_2.pCount = 3;
        _FPB_2.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(2, &_FPB_2));
}

pascal void fRequestEdit2(word type, long id, handle data, word fFlag)
{
    _FPB_0.pCount = 2;
    _FPB_0.resType = type;
    _FPB_0.resID = id;

    if (data) {
        _FPB_0.pCount = 3;
        _FPB_0.resData = data;
    }
    else
        _FPB_0.resData = 0L;

    if (fFlag) {
        _FPB_0.pCount = 4;
        _FPB_0.special = fFlag;
    }

    _FTOOLERROR(FSTACK(14, &_FPB_0));

}

pascal void fResourceConverter2(word type, long procPtr, word flag)
{
    _FPB_7.pCount = 3;
    _FPB_7.resType = type;
    _FPB_7.converterProc = procPtr;
    _FPB_7.logFlags = flag;

    _FTOOLERROR(FSTACK(24, &_FPB_7));

}

pascal void fSaveScrap2(word type, long id, handle data, word scrap)
{
    _FPB_0.pCount = 4;
    _FPB_0.resType = type;
    _FPB_0.resID = id;
    _FPB_0.resData = data;
    _FPB_0.special = scrap;

    _FTOOLERROR(FSTACK(32, &_FPB_0));
}

pascal void fSelectorMenu2(word type, long menuID, handle menuData, word menuCount, word fid)
{
    _FPB_0.pCount = 5;
    _FPB_0.resType = type;
    _FPB_0.resID = menuID;
    _FPB_0.resData = menuData;
    _FPB_0.special = menuCount;
    _FPB_0.resFileID = fid;

    _FTOOLERROR(FSTACK(35, &_FPB_0));

}

pascal void fSelectorRequest2(word type, long id, word menuID)
{
    _FPB_0.pCount = 4;
    _FPB_0.resType = type;
    _FPB_0.resID = id;
    _FPB_0.special = menuID;

    _FTOOLERROR(FSTACK(34, &_FPB_0));

}

pascal void fSetPrivateData2(GrafPortPtr winPtr, long taskMask, word sig, handle data)
{
    _FPB_6.pCount = 2;
    _FPB_6.winPtr = (Pointer) winPtr;
    _FPB_6.remTaskMask = taskMask;

    if (sig || data) {
        _FPB_6.pCount = 4;
        _FPB_6.remSignature = sig;
        _FPB_6.Data = data;
    }

    _FTOOLERROR(FSTACK(16, &_FPB_6));
}

pascal word fSetResourceAttr2(word type, long id, word attr, word fid)
{
    _FPB_0.pCount = 4;
    _FPB_0.resType = type;
    _FPB_0.resID = id;
    _FPB_0.special = attr;

    if (fid) {
        _FPB_0.pCount = 5;
        _FPB_0.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(23, &_FPB_0));

}

pascal long fSetResourceID2(word type, long oldID, long newID, word fid)
{
    _FPB_1.pCount = 3;
    _FPB_1.resType = type;
    _FPB_1.resID = oldID;
    _FPB_1.result = newID;

    if (fid) {
        _FPB_1.pCount = 4;
        _FPB_1.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(21, &_FPB_1));

    return _FPB_1.result;
}

pascal void fSetResourceName2(word type, long id, char *name)
{
    _FPB_3.pCount = 3;
    _FPB_3.resType = type;
    _FPB_3.resID = id;
    _FPB_3.resName = name;

    _FTOOLERROR(FSTACK(9, &_FPB_3));

}

pascal handle fSpecialMagic2(word type, long id, handle data, word action, word fid)
{
    _FPB_0.pCount = 5;
    _FPB_0.resType = type;
    _FPB_0.resID = id;
    _FPB_0.resData = data;
    _FPB_0.special = action;
    _FPB_0.resFileID = fid;

    _FTOOLERROR(FSTACK(30, &_FPB_0));

    return _FPB_0.resData;
}

pascal void fSpinCursor2(void)
{
    FSTACK(37, 0L);

    _FTOOLERROR(0L);
}

pascal long fUniqueResourceID2(word type, long id, word fid)
{
    _FPB_2.pCount = 2;
    _FPB_2.resType = type;
    _FPB_2.resID = id;

    if (fid) {
        _FPB_2.pCount = 3;
        _FPB_2.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(17, &_FPB_2));

    return _FPB_2.resID;
}

pascal void fWriteResource2(word type, long id, word fid)
{
    _FPB_2.pCount = 2;
    _FPB_2.resType = type;
    _FPB_2.resID = id;

    if (fid) {
        _FPB_2.pCount = 3;
        _FPB_2.resFileID = fid;
    }

    _FTOOLERROR(FSTACK(6, &_FPB_2));
}
